% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_statcast_leaderboards.R
\name{scrape_savant_leaderboards}
\alias{scrape_savant_leaderboards}
\title{\strong{(legacy) Query Baseball Savant Leaderboards}}
\usage{
scrape_savant_leaderboards(
  leaderboard = "exit_velocity_barrels",
  year = 2020,
  abs = 50,
  min_pa = "q",
  min_pitches = 100,
  min_throws = 100,
  min_field = "q",
  min_run = 0,
  player_type = "batter",
  fielding_type = "player",
  oaa_position = "",
  oaa_roles = "",
  team = "",
  arsenal_type = "n_",
  run_type = "raw",
  min2b = 5,
  min3b = 0,
  position = "",
  bats = "",
  hand = ""
)
}
\arguments{
\item{leaderboard}{The type of leaderboard to retrieve, input as a string. Current
options include exit_velocity_barrels, expected_statistics, pitch_arsenal,
outs_above_average, directional_oaa, catch_probability, pop_time, sprint_speed, and
running_splits_90_ft, arm_strength.}

\item{year}{The season for which you want data.}

\item{abs}{The minimum number of batted balls. Applies only to exit_velocity_barrels
leaderboards.}

\item{min_pa}{Minimum number of plate appearances. Can be a number or 'q' for qualified batters.}

\item{min_pitches}{Minimum number of pitches thrown.}

\item{min_throws}{Minimum number of throwing opportunities.}

\item{min_field}{Minimum number of fieding opportunities.}

\item{min_run}{Minimum number of running opportunities.}

\item{player_type}{One of either 'batter' or pitcher. For the expected_statistics
leaderboard, 'batter-team' and 'pitcher-team' are also available.}

\item{fielding_type}{One of either 'player' or 'team'.}

\item{oaa_position}{Can be either the number position of a player or 'if' or 'of' for
position categories.}

\item{oaa_roles}{Can be either the number position of a player or 'if' or 'of' for
position categories.}

\item{team}{An abbreviation for a team. Can be left blank.}

\item{arsenal_type}{One of either 'n_', 'avg_spin', or 'avg_speed'.}

\item{run_type}{One of either 'percent' or 'raw'.}

\item{min2b}{The minimum number of throwing attempts to second base.}

\item{min3b}{The minimum number of throwing attempts to third base.}

\item{position}{The numeric position of the player. For DH use 10. Can be left blank.}

\item{bats}{The handedness of the batter. One of 'R' or 'L'. Can be left blank.}

\item{hand}{The handedness of the pitcher. One of 'R' or 'L'. Can be left blank.}
}
\value{
Returns a tibble of Statcast leaderboard data.
}
\description{
\strong{(legacy) Query Baseball Savant Leaderboards}
}
\keyword{legacy}
