% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_team_info.R
\name{mlb_team_info}
\alias{mlb_team_info}
\title{\strong{MLB Team Info}}
\usage{
mlb_team_info(team_id = NULL, season = NULL, sport_id = NULL)
}
\arguments{
\item{team_id}{The team_id to return team data for.}

\item{season}{The season to return team data for the given year.}

\item{sport_id}{The sport_id to return a directory of team data for a particular club in a sport.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   all_star_status \tab character \cr
   team_id \tab integer \cr
   team_full_name \tab character \cr
   link \tab character \cr
   season \tab integer \cr
   team_code \tab character \cr
   file_code \tab character \cr
   team_abbreviation \tab character \cr
   team_name \tab character \cr
   location_name \tab character \cr
   first_year_of_play \tab character \cr
   short_name \tab character \cr
   franchise_name \tab character \cr
   club_name \tab character \cr
   active \tab logical \cr
   venue_id \tab integer \cr
   venue_name \tab character \cr
   venue_link \tab character \cr
   spring_venue_id \tab integer \cr
   spring_venue_link \tab character \cr
   league_id \tab integer \cr
   league_name \tab character \cr
   league_link \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
   sport_name \tab character \cr
}
}
\description{
\strong{MLB Team Info}
}
\examples{
\donttest{
  try(mlb_team_info(team_id = 147))
}
}
