% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permVint.R
\name{permVint}
\alias{permVint}
\title{permVint}
\usage{
permVint(model, data, trees, response, numTreesPerm = NULL, top = NULL)
}
\arguments{
\item{model}{Model created from either the BART, dbarts or bartMachine packages.}

\item{data}{A data frame containing variables in the model.}

\item{trees}{A data frame created by extractTreeData function.}

\item{response}{The name of the response for the fit.}

\item{numTreesPerm}{The number of trees to be used in the null model.
As suggested by Chipman (2009), a small number of trees is recommended (~20) to force important
variables to used in the model. If NULL, then the number of trees from the true model is used.}

\item{top}{Display only the top X interactions.}
}
\value{
A variable interaction plot. Note that for a dbarts fit, due to the internal workings of
dbarts, the null model is hard-coded to 20 trees, a burn-in of 100, and 1000 iterations. Both a
BART and bartMachine null model will extract the identical parameters from the original model.
}
\description{
A variable interaction evaluation which creates a null model by
permuting the response, rebuilding the model, and calculating the inclusion proportion (IP)
of adjacent splits on the null model.
The final result displayed is the original model's IP minus the null IP.
}
