% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology.R
\name{save_phenology}
\alias{save_phenology}
\alias{load_phenology}
\alias{save_load_phenology}
\title{Save/load a phenology}
\usage{
save_phenology(
  pheno,
  .storage,
  .submodels = c("onset", "diapause", "mortality", "development"),
  .overwrite = FALSE,
  .ext = ".tif",
  .quiet = FALSE
)

load_phenology(
  .storage,
  .submodels = c("onset", "diapause", "mortality", "development"),
  .ext = ".tif",
  .quiet = FALSE
)
}
\arguments{
\item{pheno}{A phenology, calculated with \code{\link[=phenology]{phenology()}}.}

\item{.storage}{Path to save/load the phenology.}

\item{.submodels}{Which submodels should be saved/loaded.}

\item{.overwrite}{Should an existing storage be overwritten?}

\item{.ext}{Extension for raster files.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}
}
\value{
\itemize{
\item \code{save_phenology()}: None
\item \code{load_phenology()}: A phenology as a list. Look \link[=analyse.phenology]{here} to find out how
a phenology can be analysed. It is not recommended to access the list elements directly.
}
}
\description{
Saves/loads a phenology to/from a path.
}
\section{Functions}{
\itemize{
\item \code{save_phenology()}: Saves a phenology to a path.

\item \code{load_phenology()}: Loads a phenology from a path.

}}
\examples{
\donttest{
# calculate phenology
p <- phenology('phenips-clim', barrks_data(), .quiet = TRUE)

# choose path to save the phenology
path <- file.path(tempdir(), 'pheno')

# save phenology
save_phenology(p, path, .overwrite = TRUE, .quiet = TRUE)


###

# load phenology from path
p2 <- load_phenology(path, .quiet = TRUE)

# plot generations
gens <- get_generations_rst(p2)
terra::plot(gens)
}
}
