% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-phenips.R
\encoding{UTF-8}
\name{model.phenips.customize}
\alias{model.phenips.customize}
\title{Customize PHENIPS}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_base}{Base temperature to calculate degree days to trigger the onset.}

\item{dd_onset_threshold}{Degree days that are required to trigger the onset of
infestation. Additionally, the maximum temperature must exceed \code{tfly}.}

\item{tfly}{Minimum temperature that beetles need to fly.}

\item{dd_development_base}{Base temperature to calculate degree days for calculating
the beetles development.}

\item{dd_total_dev}{Degree days that are required for a generation to fully
develop}

\item{dev_start, dev_end}{Share in total development when the egg development starts and the
juvenile beetle's development ends respectively. Usable if the development
below/above these thresholds should account for mating, oviposition etc.}

\item{dev_sister_brood}{Share in the total development when a sister brood
will be established.}

\item{dev_mortal_min, dev_mortal_max}{The beetles are considered to be in
white stages (egg, larva, pupa) if their development exceeds \code{dev_mortal_min}
and subceeds \code{dev_mortal_max}. During these stages, the beetles could die
caused by a mortality event. \code{NULL} means that no lower/upper threshold is
defined.}

\item{topt}{Temperature for optimal development.}

\item{tlow, tup}{Temperature below/above which no development happens.}

\item{func_btmean, func_btmax, func_btdiff}{Functions to caclulate the
effective bark temperature (see \insertCite{Baier2007;nobrackets}{barrks},
equations A.3 to A5). Each parameter will be passed as SpatRaster:
\itemize{
\item \code{tmean}: mean air temperature
\item \code{tmax}: maximum air temperature
\item \code{rad}: radiation
\item \code{btmax}: maximum bark temperature
}}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{daylength_dia}{When the daylength falls below this threshold, diapause
will be initiated.}

\item{mortality_date}{Date when all white stages (egg, larva, pupa) die.}
}
\description{
This page describes the parameters
that can be used to customize PHENIPS. The model was developed by
\insertCite{Baier2007;textual}{barrks}. Look \link[=model.phenips.customize]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for PHENIPS and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
model("phenips",

      # ==== onset ====

      dd_onset_start_date = '04-01',
      dd_onset_base = 8.3,
      dd_onset_threshold = 140,

      # ==== onset + development ====

      tfly = 16.5,

      # ==== development ====

      dd_development_base = 8.3,
      dd_total_dev = 557,
      dev_start = 0,
      dev_end = 1,
      dev_sister_brood = 0.5,
      dev_mortal_min = NULL,
      dev_mortal_max = 0.6,

      topt = 30.4,
      tlow = 8.3,
      tup = 38.9,

      func_btmean = function(tmean, rad) \{
        -0.173 + 0.0008518 * rad + 1.054 * tmean
      \},
      func_btmax = function(tmax, rad) \{
        1.656 + 0.002955 * rad + 0.534 * tmax + 0.01884 * tmax ^ 2
      \},
      func_btdiff = function(btmax) \{
        (-310.667 + 9.603 * btmax) / 24
      \},

      model_end_date = '10-31',

      # ==== diapause ====

      daylength_dia = 14.5,

      # ==== mortality ====

      mortality_date = '10-31'
)
}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.phenips.apply}}

Other model customizations: 
\code{\link{model.bso.customize}},
\code{\link{model.chapy.customize}},
\code{\link{model.joensson.customize}},
\code{\link{model.lange.customize}},
\code{\link{model.phenips_clim.customize}},
\code{\link{model.rity.customize}}
}
\concept{model customizations}
