% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bang-package.R
\docType{package}
\name{bang-package}
\alias{bang}
\alias{bang-package}
\title{bang: Bayesian Analysis, No Gibbs}
\description{
Performs Bayesian analyses using some simple commonly-used models.
The multivariate generalized ratio-of-uniforms method is used to simulate
random samples from the required posterior distribution.
The user can either choose hyperparameter values of a default prior
distribution or specify their own prior distribution.
}
\details{
Currently three conjugate hierarchical models are available:
beta-binomial, gamma-Poisson and 1-way Analysis of Variance (ANOVA).
The function \code{\link{hef}} produces random posterior samples from for the
beta-binomial and gamma-Poisson models.  The function \code{\link{hanova1}}
does this for the 1-way Analysis of Variance (ANOVA).
The \href{https://cran.r-project.org/package=rust}{rust} package is used to
produce these samples.

See
vignette("bang-a-vignette", package = "bang") for a brief introduction
to the package and
vignette("bang-b-hef-vignette", package = "bang") and
vignette("bang-c-anova-vignette", package = "bang") for illustrations
of the use of the \code{\link{hef}} and \code{\link{hanova1}} functions.
}
\references{
Northrop, P. J. (2017). rust: Ratio-of-Uniforms Simulation with
  Transformation. R package version 1.2.3.
  \url{https://cran.r-project.org/package=rust}.
}
\seealso{
\code{\link{hef}} for hierarchical exponential family models.

\code{\link{hanova1}} for hierarchical one-way analysis of
  variance (ANOVA).

\code{\link{set_user_prior}} to set a user-defined prior.
}
\author{
\strong{Maintainer}: Paul J. Northrop \email{p.northrop@ucl.ac.uk} [copyright holder]

Authors:
\itemize{
  \item Benjamin D. Hall \email{benjamin.hall.16@ucl.ac.uk} [copyright holder]
}

}
