% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{visualize_case_control_matrix}
\alias{visualize_case_control_matrix}
\title{Visualize matrix for a quantity measured on cases and controls (a single number)}
\usage{
visualize_case_control_matrix(
  mat,
  dim_names = ncol(mat),
  cell_metrics = "",
  folding_line = TRUE,
  axes = FALSE,
  xlab = "",
  ylab = "",
  asp = 1,
  title = ""
)
}
\arguments{
\item{mat}{matrix of values: upper for cases, lower for controls;}

\item{dim_names}{names of the columns, from left to right. It is also the
names of the rows, from bottom to top. Default is 1 through \code{ncol(mat)};}

\item{cell_metrics}{the meaning of number in every cell;}

\item{folding_line}{Default is \code{TRUE} for adding dashed major diagonal
line.}

\item{axes}{plot axes; default is \code{FALSE};}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{asp}{aspect ratio; default is \code{1} to ensure square shape}

\item{title}{text for the figure}
}
\value{
plotting function; no returned value.
}
\description{
Special to case-control visualization: upper right for cases, lower left
for controls.
}
