% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter.plot.R
\name{parameter.plot.bairt}
\alias{parameter.plot.bairt}
\title{Graph of marginal posterior densities}
\usage{
\method{parameter.plot}{bairt}(mcmclist, items = NULL, parameter = NULL,
  prob = c(0.05, 0.95), ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{items}{A vector to indicate the item to be plotted.}

\item{parameter}{The parameter (\emph{a}, \emph{b}, \emph{c} or
\emph{theta}) for graphing.}

\item{prob}{A vector of length two for defined the percentiles of the
posterior density.}

\item{...}{Further arguments.}
}
\value{
Graph of posterior densities of the item parameter (\emph{a}, \emph{b} or
\emph{c}).
}
\description{
Graph of marginal posterior densities for the item parameters (\emph{a},
\emph{b} or \emph{c}).
}
\details{
Graph of marginal posterior densities of the item parameter \emph{a, b}
for \emph{mcmc.2pnob} object or \emph{a, b, c} for \emph{mcmc.3pnob object}.
The center of error bar corresponds to the marginal posterior mean and
the extremes correspond to percentiles of the marginal posterior density
(These are delimited by \emph{prob}). For example,
\emph{prob = c(0.05, 0.95)} is equivalent to the 5th and 95th percentiles
of the marginal posterior density.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 400, burning = 100)
parameter.plot(model2)
parameter.plot(model2, items = c(2, 10:15))
parameter.plot(model2, items = 1:100, parameter = "theta" )

\donttest{
# For all examinees of the data MathTest
# Three-Parameter Normal Ogive Model
model3 <- mcmc.3pnob(MathTest, iter = 3500, burning = 500)
parameter.plot(model3)
parameter.plot(model3, items = c(2, 10:15))
parameter.plot(model3, items = 1:100, parameter = c("c", "theta"))
}

## End(Not run)

}
\references{
Johnson, V. E. & Albert, J. H. (1999). Ordinal Data Modeling.
New York: Springer.
}
\seealso{
\code{\link{mcmc.2pnob}}, \code{\link{mcmc.3pnob}} and
\code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
