% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggr_plot.R
\name{baggr_plot}
\alias{baggr_plot}
\title{Plotting method in baggr package}
\usage{
baggr_plot(bg, mean = FALSE, style = "intervals", prob = 0.5,
  prob_outer = 0.95, vline = TRUE, order = TRUE, ...)
}
\arguments{
\item{bg}{object of class \code{baggr}}

\item{mean}{logical; plot mean treatment effect alongside individual study effects?}

\item{style}{one of \code{areas}, \code{intervals}}

\item{prob}{Probability mass for the inner interval in visualisation}

\item{prob_outer}{Probability mass for the outer interval in visualisation}

\item{vline}{logical; show vertical line through 0 in the plot?}

\item{order}{logical; sort groups by magnitude of treatment effect?}

\item{...}{extra arguments to pass to the \code{bayesplot} functions}
}
\value{
ggplot2 object
}
\description{
Extracts study effects from the  \code{baggr} model and sends them to
one of \code{bayesplot} package plotting functions.
}
\examples{
fit <- baggr(schools, pooling = "none")
plot(fit)
plot(fit, style = "areas", order = FALSE)

}
\seealso{
\link[bayesplot:MCMC-intervals]{bayesplot::MCMC-intervals}
}
\author{
Witold Wiecek, Rachael Meager
}
