% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{global}
\alias{global}
\title{Compute global threshold backbone}
\usage{
global(
  W,
  upper = 0,
  lower = NULL,
  keepzeros = TRUE,
  class = "original",
  narrative = FALSE
)
}
\arguments{
\item{W}{A weighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix, sparse \code{\link{Matrix}}, or dataframe; (2) an edgelist in the form of a three-column matrix, sparse \code{\link{Matrix}}, or dataframe; (3) an \code{\link{igraph}} object; (4) a \code{\link{network}} object.}

\item{upper}{real, FUN, or NULL: upper threshold value or function that evaluates to an upper threshold value.}

\item{lower}{real, FUN, or NULL: lower threshold value or function that evaluates to a lower threshold value.}

\item{keepzeros}{boolean: TRUE if zero-weight edges in \code{W} should be excluded from (i.e. also be zero in) the backbone}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "sparseMatrix", "igraph", "network", "edgelist").
If "original", the backbone graph returned is of the same class as \code{W}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
Binary or signed backbone graph of class given in parameter \code{class}.
}
\description{
\code{global} extracts the backbone of a weighted network using a global threshold
}
\details{
The \code{global} function retains a edge in the backbone if its weight exceeds \code{upper}. If a \code{lower} threshold is also
specified, it returns a signed backbone in which edge weights are set to 1 if above the given upper threshold,
set to -1 if below the given lower threshold, and set to 0 otherwise. Prior to v2.0.0, the \code{global} function was
called \code{\link[=universal]{universal()}}, which is now depricated.

If \code{W} is an unweighted bipartite graph, any rows and columns that contain only zeros or only ones are removed, then
the global threshold is applied to its weighted bipartite projection.
}
\examples{
W <- matrix(sample(0:5, 100, replace = TRUE), 10) #Random weighted graph
diag(W) <- 0
W
global(W, narrative = TRUE)  #Keep all non-zero edges
global(W, upper = 4, lower = 2, narrative = TRUE)  #Signed with specified thresholds
global(W, upper = function(x)mean(x),  #Above-average --> positive edges
          lower = function(x)mean(x), narrative = TRUE)  #Below-average --> negative edges
}
\references{
{Neal, Z. P. (2014). The backbone of bipartite projections: Inferring relationships from co-authorship, co-sponsorship, co-attendance, and other co-behaviors. \emph{Social Networks, 39}, 84-97. \doi{10.1016/j.socnet.2014.06.001}}
}
