% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDiagonalization.R
\name{computeDiagonalization}
\alias{computeDiagonalization}
\title{Computes the matrix \eqn{\Delta \Sigma_{c,j}} resulting from the joint diagonalization 
for a given environment (cf. Eq.(7) in the paper). 
If the joint diagonalization was successful the matrix should 
be diagonal for all environments $j$.}
\usage{
computeDiagonalization(estConnectivity, X, env, whichEnv, main = NULL)
}
\arguments{
\item{estConnectivity}{Estimate for connectivity matrix returned by \code{backShift}.}

\item{X}{Data matrix}

\item{env}{Indicator of the experiment or the intervention type an 
observation belongs to (a numeric vector of length n).}

\item{whichEnv}{Indicator for the environment for which the matrix \eqn{\Delta\Sigma_{c,j}}$ should be computed.}

\item{main}{Optional title for plot; defaults to paste("Env.", whichEnv)}
}
\description{
Computes the matrix \eqn{\Delta \Sigma_{c,j}} resulting from the joint diagonalization 
for a given environment (cf. Eq.(7) in the paper). 
If the joint diagonalization was successful the matrix should 
be diagonal for all environments $j$.
}

