% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimFun.R
\name{getTrainTestObjFun}
\alias{getTrainTestObjFun}
\title{getTrainTestObjFun}
\usage{
getTrainTestObjFun(
  rkiwerte = babsim.hospital::rkidata,
  icuwerte = babsim.hospital::icudata,
  region = 5374,
  TrainSimStartDate = Sys.Date() - 12 * 7,
  TrainFieldStartDate = Sys.Date() - 8 * 7,
  TestSimStartDate = Sys.Date() - 8 * 7,
  TestFieldStartDate = Sys.Date() - 4 * 7,
  verbosity = 0,
  parallel = FALSE,
  percCores = NULL,
  icu = TRUE,
  icuWeights = c(1, 1),
  resourceNames = c("intensiveBed", "intensiveBedVentilation"),
  resourceEval = c("intensiveBed", "intensiveBedVentilation"),
  tryOnTestSet = TRUE
)
}
\arguments{
\item{rkiwerte}{RKI Daten}

\item{icuwerte}{ICU Daten}

\item{region}{Landkreis Id, e.g., \code{5374} fuer OBK, \code{5315} fuer Koeln,
\code{0} fuer Deutschland,
oder Bundesland ID, e.g., \code{5} fuer NRW.}

\item{TrainSimStartDate}{Start (Tag), e.g., \code{"2020-05-01"}}

\item{TrainFieldStartDate}{Start (Tag), e.g., \code{"2020-06-01"}}

\item{TestSimStartDate}{Start (Day), e.g., \code{"2020-05-01"} for test simulation data,
TestSimStartDate is usually before TestFieldStartDate}

\item{TestFieldStartDate}{Start (Day), e.g., \code{"2020-06-01"} for test field data}

\item{verbosity}{verbosity (int). Default: \code{0}}

\item{parallel}{logical}

\item{percCores}{percentage}

\item{icu}{ICU Daten}

\item{icuWeights}{Gewichtung der ICU Betten}

\item{resourceNames}{Name der Ressourcen}

\item{resourceEval}{Name der zu evaluierenden Ressourcen}

\item{tryOnTestSet}{Should results be tested on a separate test set?}
}
\description{
Generate objective functions (one for train, optionally one for test)
}
