% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/giveRegions.R
\name{giveRegions}
\alias{giveRegions}
\title{giveRegions}
\usage{
giveRegions(regs, regs_native, regs_alien)
}
\arguments{
\item{regs}{shapefile containing all regions of occurrence.}

\item{regs_native}{shapefile containing regions where the species is native.}

\item{regs_alien}{shapefile containing regions where the species is alien.}
}
\value{
This function returns a list containing three shapefiles derived by 
information supplied by GIFT. "regs" includes all the features corresponding
to regions where the species has been listed as present. "regs_native" 
includes all the features corresponding to regions where the species has 
been listed as native. And "regs_alien" includes all the features 
corresponding to regions where the species has been listed as alien.
}
\description{
Input checklist regions
}
\examples{
library(rworldmap)
world <- getMap()
regs <- world[c("Brazil","Argentina","Uruguay","Paraguay"),]
regs_native <- world[c("Brazil","Paraguay"),]
regs_alien <- world[c("Argentina"),]
regs_list <- giveRegions(regs,regs_native,regs_alien)
}
