% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_route_directions.R
\name{req_route_directions}
\alias{req_route_directions}
\title{Get Route Directions from 'Azure Maps'}
\usage{
req_route_directions(
  origin,
  destination,
  waypoints = NULL,
  params,
  tz = Sys.timezone(),
  api_key = get_azuremaps_token(),
  api_version = "2025-01-01"
)
}
\arguments{
\item{origin}{A numeric vector of length 2 with origin coordinates (longitude, latitude), or an \code{sf} object with a single POINT geometry.}

\item{destination}{A numeric vector of length 2 with destination coordinates (longitude, latitude), or an \code{sf} object with a single POINT geometry.}

\item{waypoints}{Optional. A numeric vector, a matrix of coordinates, or an \code{sf} object with POINT geometries representing intermediate stops.}

\item{params}{A list of route parameters (e.g., \code{optimizeRoute}, \code{routeOutputOptions}, \code{maxRouteCount}, \code{travelMode}). See the \href{https://learn.microsoft.com/en-us/rest/api/maps/route/post-route-directions?view=rest-maps-2025-01-01&tabs=HTTP}{API documentation}}

\item{tz}{A string specifying the timezone. Defaults to the system's timezone.}

\item{api_key}{The 'Azure Maps' API key. Defaults to the value retrieved by \code{get_azuremaps_token()}.}

\item{api_version}{The API version to use. Defaults to "2025-01-01".}
}
\value{
An \code{httr2_response} object from the 'Azure Maps' API.
}
\description{
Requests route directions from 'Azure Maps' API using origin, destination, waypoints, and route parameters.
}
\examples{
\dontrun{
origin <- c(-122.201399, 47.608678)
destination <- c(-122.201669, 47.615076)
waypoints <- c(-122.20687, 47.612002)

params <- list(
  optimizeRoute = "fastestWithTraffic",
  routeOutputOptions = "routePath",
  maxRouteCount = 3,
  travelMode = "driving"
)

response <- req_route_directions(origin, destination, waypoints, params)
}

}
