% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\name{create_queue}
\alias{create_queue}
\alias{delete_queue}
\title{Create or delete a queue}
\usage{
create_queue(name, attributes = NULL, query = NULL, ...)

delete_queue(queue, query = NULL, ...)
}
\arguments{
\item{name}{A character string containing a name for the queue.}

\item{attributes}{Currently ignored}

\item{query}{A list specifying additional query arguments to be passed to the \code{query} argument of \code{\link{sqsHTTP}}.}

\item{...}{Additional arguments passed to \code{\link{sqsHTTP}}.}

\item{queue}{A character string containing a queue URL, or the name of the queue.}
}
\value{
If successful, \code{create_queue} returns a character string containing an SQS Queue URL and \code{delete_queue} returns a logical \code{TRUE}. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Create or delete an SQS queue
}
\details{
\code{create_queue} creates a new SQS queue; \code{delete_queue} deletes a queue.
}
\examples{
\dontrun{
  # list current queues
  list_queues()
  
  # create a queue
  queue <- create_queue("ExampleQueue")
  get_queue_url("ExampleQueue")
  
  # send message to queue
  send_msg("ExampleQueue", "This is a test message")
  # receive a message
  (m <- receive_msg("ExampleQueue", timeout = 0))
  
  # delete a message from queue
  delete_msg("ExampleQueue", m$ReceiptHandle[1])
  
  # delete queue
  delete_queue("ExampleQueue")
  
}
}
\author{
Thomas J. Leeper
}
\references{
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html}{CreateQueue}
\href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_DeleteQueue.html}{DeleteQueue}
}
\seealso{
\code{\link{get_queue_attrs}} \code{\link{set_queue_attrs}} \code{link{purge_queue}}
}

