% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_put_attributes}
\alias{ecs_put_attributes}
\title{Put Attributes}
\usage{
ecs_put_attributes(
  cluster = NULL,
  attributes = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply...}

\item{attributes}{List. The attributes to apply to your resource.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create or update an attribute on an Amazon
ECS resource. If the attribute does not exist, it is created. If the
attribute exists, its value is replaced with the specified value. To
delete an attribute, use DeleteAttributes. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes}{Attributes}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}
\section{cluster}{

The short name or full Amazon Resource
Name (ARN) of the cluster that contains the resource to apply
attributes. If you do not specify a cluster, the default cluster is
assumed.
}

\section{attributes}{

The attributes to apply to your resource.
You can specify up to 10 custom attributes per resource. You can specify
up to 10 attributes in a single call.
}

