% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_describe_clusters}
\alias{ecs_describe_clusters}
\title{Describe Clusters}
\usage{
ecs_describe_clusters(
  clusters = NULL,
  include = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{clusters}{List. A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries.}

\item{include}{List.   Whether to include additional information about your clusters in the response.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your
clusters.
}
\section{clusters}{

A list of up to 100 cluster names or full cluster
Amazon Resource Name (ARN) entries. If you do not specify a cluster, the
default cluster is assumed.
}

\section{include}{


Whether to include additional information about your clusters in the
response. If this field is omitted, the attachments, statistics, and
tags are not included.

If \code{ATTACHMENTS} is specified, the attachments for the container
instances or tasks within the cluster are included.

If \code{SETTINGS} is specified, the settings for the cluster are included.

If \code{STATISTICS} is specified, the following additional information,
separated by launch type, is included:
\itemize{
\item runningEC2TasksCount
\item runningFargateTasksCount
\item pendingEC2TasksCount
\item pendingFargateTasksCount
\item activeEC2ServiceCount
\item activeFargateServiceCount
\item drainingEC2ServiceCount
\item drainingFargateServiceCount
}

If \code{TAGS} is specified, the metadata tags associated with the cluster
are included.
}

