% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_traffic_mirror_filter_rule}
\alias{ec2_create_traffic_mirror_filter_rule}
\title{Create Traffic Mirror Filter Rule}
\usage{
ec2_create_traffic_mirror_filter_rule(
  TrafficMirrorFilterId,
  TrafficDirection,
  RuleNumber,
  RuleAction,
  DestinationCidrBlock,
  SourceCidrBlock,
  DestinationPortRange = NULL,
  SourcePortRange = NULL,
  Protocol = NULL,
  Description = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{TrafficMirrorFilterId}{Character. The ID of the filter that this rule is associated with.}

\item{TrafficDirection}{Character. The type of traffic (\code{ingress} \| \code{egress}).}

\item{RuleNumber}{Integer. The number of the Traffic Mirror rule.}

\item{RuleAction}{Character. The action to take (\code{accept} \| \code{reject}) on the filtered traffic.}

\item{DestinationCidrBlock}{Character. The destination CIDR block to assign to the Traffic Mirror rule.}

\item{SourceCidrBlock}{Character. The source CIDR block to assign to the Traffic Mirror rule.}

\item{DestinationPortRange}{Object. The destination port range.[optional]}

\item{SourcePortRange}{Object. The source port range.[optional]}

\item{Protocol}{Integer.   The protocol, for example UDP, to assign to the Traffic Mirror rule.[optional]}

\item{Description}{Character. The description of the Traffic Mirror rule.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Traffic Mirror Filter Rule
}
\section{TrafficMirrorFilterId}{

The
ID of the filter that this rule is associated
with.
}

\section{TrafficDirection}{

The type of traffic (\code{ingress} \|
\code{egress}).
}

\section{RuleNumber}{

The number of the Traffic Mirror rule.
This number must be unique for each Traffic Mirror rule in a given
direction. The rules are processed in ascending order by rule
number.
}

\section{RuleAction}{

The action to take (\code{accept} \| \code{reject}) on
the filtered traffic.
}

\section{DestinationCidrBlock}{

The destination CIDR block to
assign to the Traffic Mirror rule.
}

\section{SourceCidrBlock}{

The source CIDR
block to assign to the Traffic Mirror rule.
}

\section{DestinationPortRange}{

The
destination port range.
}

\section{SourcePortRange}{

The source port
range.
}

\section{Protocol}{


The protocol, for example UDP, to assign to the Traffic Mirror rule.

For information about the protocol value, see \href{https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}
on the Internet Assigned Numbers Authority (IANA) website.
}

\section{Description}{

The description of the Traffic Mirror
rule.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

