% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_network_acl_entry}
\alias{ec2_create_network_acl_entry}
\title{Create Network Acl Entry}
\usage{
ec2_create_network_acl_entry(
  Egress,
  NetworkAclId,
  Protocol,
  RuleAction,
  RuleNumber,
  CidrBlock = NULL,
  DryRun = NULL,
  Icmp = NULL,
  Ipv6CidrBlock = NULL,
  PortRange = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Egress}{Logical. Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).}

\item{NetworkAclId}{Character. The ID of the network ACL.}

\item{Protocol}{Character. The protocol number.}

\item{RuleAction}{Character. Indicates whether to allow or deny the traffic that matches the rule.}

\item{RuleNumber}{Integer.   The rule number for the entry (for example, 100).}

\item{CidrBlock}{Character. The IPv4 network range to allow or deny, in CIDR notation (for example \verb{172.16.0.0/24}). We modify...[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Icmp}{Object. ICMP protocol: The ICMP or ICMPv6 type and code.[optional]}

\item{Ipv6CidrBlock}{Character. The IPv6 network range to allow or deny, in CIDR notation (for example \verb{2001:db8:1234:1a00::/64}).[optional]}

\item{PortRange}{Object. TCP or UDP protocols: The range of ports the rule applies to.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Network Acl Entry
}
\section{Egress}{

Indicates whether this is an egress
rule (rule is applied to traffic leaving the
subnet).
}

\section{NetworkAclId}{

The ID of the network
ACL.
}

\section{Protocol}{

The protocol number. A value of \'-1\' means
all protocols. If you specify \'-1\' or a protocol number other than
\'6\' (TCP), \'17\' (UDP), or \'1\' (ICMP), traffic on all ports is
allowed, regardless of any ports or ICMP types or codes that you
specify. If you specify protocol \'58\' (ICMPv6) and specify an IPv4
CIDR block, traffic for all ICMP types and codes allowed, regardless of
any that you specify. If you specify protocol \'58\' (ICMPv6) and
specify an IPv6 CIDR block, you must specify an ICMP type and
code.
}

\section{RuleAction}{

Indicates whether to allow or deny the traffic
that matches the rule.
}

\section{RuleNumber}{


The rule number for the entry (for example, 100). ACL entries are
processed in ascending order by rule number.

Constraints: Positive integer from 1 to 32766. The range 32767 to 65535
is reserved for internal use.
}

\section{CidrBlock}{

The IPv4 network range to allow or deny, in CIDR
notation (for example \verb{172.16.0.0/24}). We modify the specified CIDR
block to its canonical form; for example, if you specify
\verb{100.68.0.18/18}, we modify it to
\verb{100.68.0.0/18}.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Icmp}{

ICMP protocol: The ICMP or
ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or
protocol 58 (ICMPv6) with an IPv6 CIDR block.
}

\section{Ipv6CidrBlock}{

The
IPv6 network range to allow or deny, in CIDR notation (for example
\verb{2001:db8:1234:1a00::/64}).
}

\section{PortRange}{

TCP or UDP protocols:
The range of ports the rule applies to. Required if specifying protocol
6 (TCP) or 17 (UDP).
}

