% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_authorize_security_group_ingress}
\alias{ec2_authorize_security_group_ingress}
\title{Authorize Security Group Ingress}
\usage{
ec2_authorize_security_group_ingress(
  CidrIp = NULL,
  FromPort = NULL,
  GroupId = NULL,
  GroupName = NULL,
  IpPermissions = NULL,
  IpProtocol = NULL,
  SourceSecurityGroupName = NULL,
  SourceSecurityGroupOwnerId = NULL,
  ToPort = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{CidrIp}{Character.   The IPv4 address range, in CIDR format.[optional]}

\item{FromPort}{Integer.   The start of port range for the TCP and UDP protocols, or an ICMP type number.[optional]}

\item{GroupId}{Character. The ID of the security group.[optional]}

\item{GroupName}{Character. [EC2-Classic, default VPC] The name of the security group.[optional]}

\item{IpPermissions}{List. The sets of IP permissions.[optional]}

\item{IpProtocol}{Character.   The IP protocol name (\code{tcp}, \code{udp}, \code{icmp}) or number (see \href{http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers})....[optional]}

\item{SourceSecurityGroupName}{Character. [EC2-Classic, default VPC] The name of the source security group.[optional]}

\item{SourceSecurityGroupOwnerId}{Character. [nondefault VPC] The AWS account ID for the source security group, if the source security group...[optional]}

\item{ToPort}{Integer.   The end of port range for the TCP and UDP protocols, or an ICMP code number.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Authorize Security Group Ingress
}
\section{CidrIp}{


The IPv4 address range, in CIDR format. You can\'t specify this
parameter when specifying a source security group. To specify an IPv6
address range, use a set of IP permissions.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.
}

\section{FromPort}{


The start of port range for the TCP and UDP protocols, or an ICMP type
number. For the ICMP type number, use \code{-1} to specify all types. If you
specify all ICMP types, you must specify all codes.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.
}

\section{GroupId}{

The ID of the security group. You must specify
either the security group ID or the security group name in the request.
For security groups in a nondefault VPC, you must specify the security
group ID.
}

\section{GroupName}{

[EC2-Classic, default VPC] The name of
the security group. You must specify either the security group ID or the
security group name in the request.
}

\section{IpPermissions}{

The sets of IP
permissions.
}

\section{IpProtocol}{


The IP protocol name (\code{tcp}, \code{udp}, \code{icmp}) or number (see \href{http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}).
To specify \code{icmpv6}, use a set of IP permissions.

[VPC only] Use \code{-1} to specify all protocols. If you specify \code{-1} or a
protocol other than \code{tcp}, \code{udp}, or \code{icmp}, traffic on all ports is
allowed, regardless of any ports you specify.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.
}

\section{SourceSecurityGroupName}{

[EC2-Classic, default VPC] The name of the source
security group. You can\'t specify this parameter in combination with
the following parameters: the CIDR IP address range, the start of the
port range, the IP protocol, and the end of the port range. Creates
rules that grant full ICMP, UDP, and TCP access. To create a rule with a
specific IP protocol and port range, use a set of IP permissions
instead. For EC2-VPC, the source security group must be in the same
VPC.
}

\section{SourceSecurityGroupOwnerId}{

[nondefault VPC] The AWS account ID for the
source security group, if the source security group is in a different
account. You can\'t specify this parameter in combination with the
following parameters: the CIDR IP address range, the IP protocol, the
start of the port range, and the end of the port range. Creates rules
that grant full ICMP, UDP, and TCP access. To create a rule with a
specific IP protocol and port range, use a set of IP permissions
instead.
}

\section{ToPort}{


The end of port range for the TCP and UDP protocols, or an ICMP code
number. For the ICMP code number, use \code{-1} to specify all codes. If you
specify all ICMP types, you must specify all codes.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

