% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_update_security_group_rule_descriptions_egress}
\alias{ec2_update_security_group_rule_descriptions_egress}
\title{Update Security Group Rule Descriptions Egress}
\usage{
ec2_update_security_group_rule_descriptions_egress(
  IpPermissions,
  DryRun = NULL,
  GroupId = NULL,
  GroupName = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{IpPermissions}{List. The IP permissions for the security group rule.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{GroupId}{String. The ID of the security group.[optional]}

\item{GroupName}{String. [Default VPC] The name of the security group.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Update Security Group Rule Descriptions Egress
}
\section{IpPermissions}{

The IP permissions for the
security group rule.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{GroupId}{

The ID of the security
group. You must specify either the security group ID or the security
group name in the request. For security groups in a nondefault VPC, you
must specify the security group ID.
}

\section{GroupName}{

[Default VPC]
The name of the security group. You must specify either the security
group ID or the security group name in the
request.
}

