% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_import_key_pair}
\alias{ec2_import_key_pair}
\title{Import Key Pair}
\usage{
ec2_import_key_pair(
  KeyName,
  PublicKeyMaterial,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{KeyName}{String. A unique name for the key pair.}

\item{PublicKeyMaterial}{String. The public key.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to apply to the imported key pair.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Import Key Pair
}
\section{KeyName}{

A unique name for the key
pair.
}

\section{PublicKeyMaterial}{

The public key. For API calls, the text must
be base64-encoded. For command line tools, base64 encoding is performed
for you.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to apply to the
imported key pair.
}

