% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_console_screenshot}
\alias{ec2_get_console_screenshot}
\title{Get Console Screenshot}
\usage{
ec2_get_console_screenshot(
  InstanceId,
  DryRun = NULL,
  WakeUp = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceId}{String. The ID of the instance.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{WakeUp}{Logical. When set to \code{true}, acts as keystroke input and wakes up an instance that\'s in standby or \'sleep\'...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Get Console Screenshot
}
\section{InstanceId}{

The ID of the instance.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{WakeUp}{

When set
to \code{true}, acts as keystroke input and wakes up an instance that\'s in
standby or \'sleep\' mode.
}

