% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpc_endpoint_service_configurations}
\alias{ec2_describe_vpc_endpoint_service_configurations}
\title{Describe Vpc Endpoint Service Configurations}
\usage{
ec2_describe_vpc_endpoint_service_configurations(
  DryRun = NULL,
  ServiceId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ServiceId}{List. The IDs of one or more services.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the VPC endpoint service
configurations in your account (your
services).
}
\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ServiceId}{

The IDs of one or more
services.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{service-name} - The name of the service.
\item \code{service-id} - The ID of the service.
\item \code{service-state} - The state of the service (\code{Pending} \| \code{Available}
\| \code{Deleting} \| \code{Deleted} \| \code{Failed}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}
}

\section{MaxResults}{

The maximum number of results to return for the
request in a single page. The remaining results of the initial request
can be seen by sending another request with the returned \code{NextToken}
value. This value can be between 5 and 1,000; if \code{MaxResults} is given a
value larger than 1,000, only 1,000 results are
returned.
}

