% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_client_vpn_route}
\alias{ec2_delete_client_vpn_route}
\title{Delete Client Vpn Route}
\usage{
ec2_delete_client_vpn_route(
  ClientVpnEndpointId,
  DestinationCidrBlock,
  TargetVpcSubnetId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{String. The ID of the Client VPN endpoint from which the route is to be deleted.}

\item{DestinationCidrBlock}{String. The IPv4 address range, in CIDR notation, of the route to be deleted.}

\item{TargetVpcSubnetId}{String. The ID of the target subnet used by the route.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes a route from a Client VPN
endpoint. You can only delete routes that you manually added using the
\strong{CreateClientVpnRoute} action. You cannot delete routes that were
automatically added when associating a subnet. To remove routes that
have been automatically added, disassociate the target subnet from the
Client VPN endpoint.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint from which the route is to be deleted.
}

\section{DestinationCidrBlock}{

The
IPv4 address range, in CIDR notation, of the route to be
deleted.
}

\section{TargetVpcSubnetId}{

The ID of the target subnet used by the
route.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

