% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_route_table}
\alias{ec2_create_route_table}
\title{Create Route Table}
\usage{
ec2_create_route_table(
  VpcId,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to assign to the route table.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Route Table
}
\section{VpcId}{

The ID of the
VPC.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to assign to the
route table.
}

