% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_local_gateway_route}
\alias{ec2_create_local_gateway_route}
\title{Create Local Gateway Route}
\usage{
ec2_create_local_gateway_route(
  DestinationCidrBlock,
  LocalGatewayRouteTableId,
  LocalGatewayVirtualInterfaceGroupId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DestinationCidrBlock}{String. The CIDR range used for destination matches.}

\item{LocalGatewayRouteTableId}{String. The ID of the local gateway route table.}

\item{LocalGatewayVirtualInterfaceGroupId}{String. The ID of the virtual interface group.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Creates a static route for the specified local
gateway route table.
}
\section{DestinationCidrBlock}{

The CIDR range used for
destination matches. Routing decisions are based on the most specific
match.
}

\section{LocalGatewayRouteTableId}{

The ID of the local gateway route
table.
}

\section{LocalGatewayVirtualInterfaceGroupId}{

The ID of the virtual interface
group.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

