% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_dhcp_options}
\alias{ec2_create_dhcp_options}
\title{Create Dhcp Options}
\usage{
ec2_create_dhcp_options(
  DhcpConfiguration,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DhcpConfiguration}{List. A DHCP configuration option.}

\item{TagSpecification}{List. The tags to assign to the DHCP option.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Dhcp Options
}
\section{DhcpConfiguration}{

A DHCP
configuration option.
}

\section{TagSpecification}{

The tags to assign to the DHCP
option.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

