% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_default_subnet}
\alias{ec2_create_default_subnet}
\title{Create Default Subnet}
\usage{
ec2_create_default_subnet(
  AvailabilityZone,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AvailabilityZone}{String. The Availability Zone in which to create the default subnet.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Creates a default subnet with a size \verb{/20} IPv4
CIDR block in the specified Availability Zone in your default VPC. You
can have only one default subnet per Availability Zone. For more
information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet}{Creating a Default Subnet}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{AvailabilityZone}{

The Availability Zone in
which to create the default subnet.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

