% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_attach_vpn_gateway}
\alias{ec2_attach_vpn_gateway}
\title{Attach Vpn Gateway}
\usage{
ec2_attach_vpn_gateway(
  VpcId,
  VpnGatewayId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC.}

\item{VpnGatewayId}{String. The ID of the virtual private gateway.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Attach Vpn Gateway
}
\section{VpcId}{

The ID of the
VPC.
}

\section{VpnGatewayId}{

The ID of the virtual private
gateway.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

