% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$likelihood_ratio}
\alias{AUTO_VI$likelihood_ratio}
\title{Compute the likelihood ratio using the simulated result}
\arguments{
\item{vss}{Numeric. The observed visual signal strength.}

\item{dist_1}{Numeric. A vector of visual signal strength for plots following
the first distribution (bootstrap distribution by default).}

\item{dist_2}{Numeric. A vector of visual signal strength for plots following
the second distribution (null distribution by default).}
}
\value{
A named vector with three elements \code{likelihood_1},
\code{likelihood_2} and \code{likelihood_ratio}.
}
\description{
This function estimates the likelihood
of observing the visual signal strength in terms of the bootstrapped
distribution and the simulated null distribution, and computes the ratio
between these two likelihood.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$likelihood_ratio(
  vss = self$check_result$observed$vss,
  dist_1 = self$check_result$boot$vss,
  dist_2 = self$check_result$null$vss
)
}\if{html}{\out{</div>}}
}
}
\examples{

dist_1 <- rnorm(100, 0, 1)
dist_2 <- rnorm(100, 1, 1)
AUTO_VI$likelihood_ratio(0, dist_1, dist_2)
}
