% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_ds_slide.R
\name{t_ds_slide}
\alias{t_ds_slide}
\title{Discontinue table}
\usage{
t_ds_slide(adsl, arm = "TRT01P", split_by_study = FALSE, side_by_side = NULL)
}
\arguments{
\item{adsl}{ADSL data}

\item{arm}{Arm variable, character, "`TRT01P" by default.}

\item{split_by_study}{Split by study, building structured header for tables}

\item{side_by_side}{"GlobalAsia" or "GlobalAsiaChina" to define the side by side requirement}
}
\description{
Discontinue table
}
\note{
* Default arm variables are set to `"TRT01A"` for safety output, and
 `"TRT01P"` for efficacy output
}
\examples{
library(dplyr)
adsl <- eg_adsl \%>\%
  mutate(DISTRTFL = sample(c("Y", "N"), size = nrow(eg_adsl), replace = TRUE, prob = c(.1, .9))) \%>\%
  preprocess_t_ds()
out1 <- t_ds_slide(adsl, "TRT01P")
print(out1)
generate_slides(out1, paste0(tempdir(), "/ds.pptx"))

out2 <- t_ds_slide(adsl, "TRT01P", split_by_study = TRUE)
print(out2)

}
