% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawSamples.R
\name{drawSamples}
\alias{drawSamples}
\title{Simulate data from auto- models}
\usage{
drawSamples(beta, gamma, X, A, burnIn = 300, nSamples, y = NULL)
}
\arguments{
\item{beta}{coefficient vector (for the autologistic model) or matrix (for the automultinomial model)}

\item{gamma}{the value of the autocorrelation parameter}

\item{X}{the design matrix}

\item{A}{the (square symmetric) adjacency matrix encoding the neighborhood structure}

\item{burnIn}{the number of burnin samples to be used. Defaults to 300}

\item{nSamples}{the number of samples to draw}

\item{y}{optional starting configuration, in factor form. Defaults to NULL}
}
\value{
simulated samples
}
\description{
Generates data from the autologistic and automultinomial
models via Gibbs sampling. See the vignette for an example of use.
}
\examples{
##########generating coefficient values and data
#adjacency matrix A
A=igraph::get.adjacency(igraph::make_lattice(c(40,40)))

#design matrix
X=cbind(rep(1,1600),matrix(rnorm(1600*4),ncol=4))

#correlation parameter
gamma=0.6

#2 response categories (1 column in coefficient matrix)
beta2=matrix(rnorm(5)*0.3,ncol=1)
#This example uses a short burnIn period. Use a longer burnIn in practice.
y2=drawSamples(beta2,gamma,X,A,burnIn=1,nSamples=1)

#3 response categories (2 columns in coefficient matrix)
beta3=matrix(rnorm(10)*0.3,ncol=2)
y3=drawSamples(beta3,gamma,X,A,burnIn=1,nSamples=1)
##########
}
