% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_get_missing_deps}
\alias{am_get_missing_deps}
\title{Get missing dependencies}
\usage{
am_get_missing_deps(doc, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{heads}{Optional list of change hashes (raw vectors) to check for
missing dependencies. If \code{NULL} (default), checks the current heads.}
}
\value{
A list of raw vectors (change hashes of missing dependencies).
Returns an empty list if no dependencies are missing.
}
\description{
Returns the change hashes of dependencies that are referenced by the
document but not present in its change history. This can happen when
changes are applied out of order or when a document is partially synced.
}
\examples{
doc <- am_create()
doc$key <- "value"
am_commit(doc)

# Complete document has no missing deps
missing <- am_get_missing_deps(doc)
length(missing)  # 0

am_close(doc)

}
