% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_marks_at}
\alias{am_marks_at}
\title{Get marks at a specific position}
\usage{
am_marks_at(obj, position)
}
\arguments{
\item{obj}{An Automerge object ID (must be a text object)}

\item{position}{Integer position (0-based inter-character position) to query.
See \code{\link[=am_mark]{am_mark()}} for indexing details.}
}
\value{
A list of marks that include the specified position. Returns an empty
list if no marks cover that position.
}
\description{
Retrieves marks that include a specific position in a text object. This
function efficiently filters marks at the C level, avoiding the overhead
of converting all marks to R objects.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

am_mark(text_obj, 0, 5, "bold", TRUE)
am_mark(text_obj, 2, 7, "underline", TRUE)

# Get marks at position 3 (inside "Hello")
marks_at_3 <- am_marks_at(text_obj, 3)
marks_at_3
# List of 2 marks (both "bold" and "underline" include position 3)

am_close(doc)

}
