% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_mark}
\alias{am_mark}
\title{Create a mark on a text range}
\usage{
am_mark(obj, start, end, name, value, expand = AM_MARK_EXPAND_NONE)
}
\arguments{
\item{obj}{An Automerge object ID (must be a text object)}

\item{start}{Integer start position (0-based inter-character position, inclusive)}

\item{end}{Integer end position (0-based inter-character position, exclusive)}

\item{name}{Character string identifying the mark (e.g., "bold", "comment")}

\item{value}{The mark's value (any Automerge-compatible type: NULL, logical,
integer, numeric, character, raw, POSIXct, or am_counter)}

\item{expand}{Character string controlling mark expansion behavior when text
is inserted at boundaries. Options:
\describe{
\item{"none"}{Mark does not expand (default)}
\item{"before"}{Mark expands to include text inserted before start}
\item{"after"}{Mark expands to include text inserted after end}
\item{"both"}{Mark expands in both directions}
}
Use the constants \link{AM_MARK_EXPAND_NONE}, \link{AM_MARK_EXPAND_BEFORE},
\link{AM_MARK_EXPAND_AFTER}, or \link{AM_MARK_EXPAND_BOTH}.}
}
\value{
The text object \code{obj} (invisibly)
}
\description{
Marks attach metadata or formatting information to a range of text.
Unlike simple annotations, marks are CRDT-aware and merge correctly
across concurrent edits.
}
\section{Indexing Convention}{

\strong{Mark positions use 0-based indexing} (unlike list indices which are
1-based). Positions specify locations \strong{between} characters. The range
\verb{[start, end)} includes \code{start} but excludes \code{end}.

For the text "Hello":
\preformatted{
  H e l l o
 0 1 2 3 4 5  <- positions (0-based, between characters)
}

Marking positions 0 to 5 marks all 5 characters. Marking 0 to 3 marks "Hel".
Positions count Unicode code points (characters), not bytes.
}

\section{Expand Behavior}{

The \code{expand} parameter controls what happens when text is inserted exactly
at the mark boundaries:
\itemize{
\item \code{"none"}: New text is never included in the mark
\item \code{"before"}: Text inserted at \code{start} is included
\item \code{"after"}: Text inserted at \code{end} is included
\item \code{"both"}: Text inserted at either boundary is included
}
}

\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

# Mark "Hello" as bold (positions 0-4, characters 0-4)
am_mark(text_obj, 0, 5, "bold", TRUE)

# Mark "World" as italic with expansion
am_mark(text_obj, 6, 11, "italic", TRUE,
        expand = AM_MARK_EXPAND_BOTH)

# Get all marks
marks <- am_marks(text_obj)
marks
}
