% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{prune_depth}
\alias{prune_depth}
\title{Prune a tree up to a specified depth.}
\usage{
prune_depth(th, names_to_keep)
}
\arguments{
\item{th}{A TreeHarp object.}

\item{names_to_keep}{The node names to keep in the pruned tree.}
}
\value{
An object of class TreeHarp.
}
\description{
Prunes a tree up to a depth specified by a set of node names.
}
\details{
This is a seldom used function. It works in this way. Given a set 
of node names, it identifies the node with the greatest depth in that set.
The function then returns the sub-tree, that contains all the nodes with a
depth smaller than or equal to that depth. If the node types slot is not NA,
then that data frame is filtered and returned too.

Take a look at the examples for a clearer picture.
}
\examples{
ex1 <- quote(x <- f(y, g(5)))
th1 <- TreeHarp(ex1, TRUE)
s1 <- prune_depth(th1, c("f", "y"))
s2 <- prune_depth(th1, c("f", "z")) # node not present!
plot(s1)
plot(s2)
}
\seealso{
\code{\link{carve_subtree}}, \code{\link{path_to_root}}, 
\code{\link{carve_mst}}
}
