% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{get_recursive_index}
\alias{get_recursive_index}
\title{Obtain an index to extract out a sub-call}
\usage{
get_recursive_index(th, node_id)
}
\arguments{
\item{th}{A TreeHarp object.}

\item{node_id}{An integer corresponding to a call within the parse tree 
(not a literal, symbol or a formal argument).}
}
\value{
A vector of indices, that can be used (together with "[[") to obtain a 
sub-call
}
\description{
Obtains an index that can be used to extract a sub-call from a language object.
}
\examples{
ex3 <- quote(x <- f(y = g(3, 4), z=1L))
t1 <- TreeHarp(ex3, TRUE)
rec_index <- get_recursive_index(t1, 6)
ex3[[rec_index + 1]]
ex3[[get_recursive_index(t1, 3)+1]]
}
