% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_score.R
\name{compute_score}
\alias{compute_score}
\alias{compute_scores}
\alias{summary.score}
\title{Compute the In-plus-out-of-questionnaire log likelihood (with DIF) (IPOQ-LL(-DIF))}
\usage{
compute_score(
  X,
  incl_set,
  type = c("ipoqll", "ipoqlldif"),
  groups_map = c(),
  init_par_iq = c(),
  init_par_oq = c(),
  optim_control_iq = c(),
  optim_control_oq = c(),
  setting_par_iq = c(),
  setting_par_oq = c(),
  method = c("fast", "novel")
)

compute_scores(
  X,
  incl_sets,
  type = c("ipoqll", "ipoqlldif"),
  step_direct = c("fixed", "forward", "backward"),
  groups_map = c(),
  init_par_iq = c(),
  init_par_oq = c(),
  optim_control_iq = c(),
  optim_control_oq = c(),
  setting_par_iq = c(),
  setting_par_oq = c(),
  cores = NULL,
  method = c("fast", "novel"),
  timeLimit = 3600
)

\method{summary}{score}(object, ...)
}
\arguments{
\item{X}{A matrix or data.frame of the observed responses (ordinal or binary response).}

\item{incl_set}{A vector of the items (columns) number in the data.frame X that are included in the included set.}

\item{type}{The type of the score. \code{ipoqll} if we ignore the presence of the DIF and \code{ipoqlldif} if we want to consider the DIF effect.}

\item{groups_map}{Matrix to map the respondents to the DIF groups.}

\item{init_par_iq}{Initial values of the parameters in the included set before the estimation begin.}

\item{init_par_oq}{Initial values of the parameters in the excluded set before the estimation begin.}

\item{optim_control_iq}{The optimisation setting of the included set. See \code{\link[stats:optim]{stats::optim()}} \code{control} parameter.}

\item{optim_control_oq}{The optimisation setting of the excluded set. See \code{\link[stats:optim]{stats::optim()}} \code{control} parameter.}

\item{setting_par_iq}{The coordinate descent optimisation setting of the included set. See \code{\link[autoRasch:autoRaschOptions]{autoRasch::autoRaschOptions()}} \code{cd_control} parameter.}

\item{setting_par_oq}{The coordinate descent optimisation setting of the excluded set. See \code{\link[autoRasch:autoRaschOptions]{autoRasch::autoRaschOptions()}} \code{cd_control} parameter.}

\item{method}{The implementation option of log likelihood function. \code{fast} using a \code{c++} implementation and \code{novel} using an \code{R} implementation.}

\item{incl_sets}{A matrix as a results of a \code{rbind} of \code{incl_set}.}

\item{step_direct}{How will you compute the criterion score. \code{fixed} for the given itemset,
\code{forward} computes all the scores of the possible combination of items if an item is added to the given set,
\code{backward}  computes all the scores of the possible combination of items if an item is removed to the given set.}

\item{cores}{Number of cores that is used in the paralellization.}

\item{timeLimit}{The maximum excution time to compute the criterion score. Exceeding the setting time, the computation will be halted.}

\item{object}{The object from the class \code{score}. The result of the score computation.}

\item{...}{further argument passed or from other method.}
}
\value{
\code{compute_score} will return a vector which contains in-questionnaire log likelihood (IQ-LL(-DIF)), out-of-questionnaire log likelihood(OQ-LL(-DIF)),
IPOQ-LL(-DIF), included set's items' number in the given initial survey, the estimated theta parameters, the estimated items' parameters in the included set,
and the estimated items' parameters in the excluded set, sequentially.

\code{compute_scores} will return a matrix as a result of the \code{rbind} operation of the \code{compute_score}'s result.
}
\description{
\code{compute_score} computes the the IPOQ-LL/IPOQ-LL-DIF score of an instrument (included set) of the given initial survey.
While \code{compute_scores} computes the IPOQ-LL/IPOQ-LL-DIF score of many (more than one) instruments (included sets) of
the given initial survey simultanously.
}
\examples{
ipoqll_score <- compute_score(shortDIF,incl_set = c(1:3),type = "ipoqll")

\dontrun{
ipoqll_scores <- compute_scores(shortDIF,incl_set = rbind(c(1:3),c(2:4)),
                                type = "ipoqll", cores = 2)
}

}
