% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebma.R
\name{ebma_mc_tol}
\alias{ebma_mc_tol}
\title{EBMA multicore tuning - parallelises over tolerance values.}
\usage{
ebma_mc_tol(
  train.preds,
  train.y,
  ebma.fold,
  y,
  L1.x,
  L2.x,
  L2.unit,
  L2.reg,
  pc.names,
  model.bs,
  model.pca,
  model.lasso,
  model.gb,
  model.svm,
  model.mrp,
  tol,
  n.draws,
  cores
)
}
\arguments{
\item{train.preds}{Predictions of classifiers on the classifier training data. A tibble.}

\item{train.y}{Outcome variable of the classifier training data. A numeric vector.}

\item{ebma.fold}{The data used for EBMA tuning. A tibble.}

\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}

\item{pc.names}{Principal Component Variable names. A character vector
containing the names of the context-level principal components variables.}

\item{model.bs}{The tuned model from the multilevel regression with best
subset selection classifier. An \code{\link[lme4]{glmer}} object.}

\item{model.pca}{The tuned model from the multilevel regression with
principal components as context-level predictors classifier. An
\code{\link[lme4]{glmer}} object.}

\item{model.lasso}{The tuned model from the multilevel regression with L1
regularization classifier. A \code{\link[glmmLasso]{glmmLasso}} object.}

\item{model.gb}{The tuned model from the gradient boosting classifier. A
\code{\link[gbm]{gbm}} object.}

\item{model.svm}{The tuned model from the support vector machine classifier.
An \code{\link[e1071]{svm}} object.}

\item{model.mrp}{The standard MrP model. An \code{\link[lme4]{glmer}} object}

\item{tol}{The tolerance values used for EBMA. A numeric vector.}

\item{n.draws}{EBMA number of samples. An integer-valued scalar specifying
the number of bootstrapped samples to be drawn from the EBMA fold and used
for tuning EBMA. Default is \eqn{100}. Passed on from \code{ebma.n.draws}.}

\item{cores}{The number of cores to be used. An integer indicating the number
of processor cores used for parallel computing. Default is 1.}
}
\value{
The classifier weights. A numeric vector.
}
\description{
\code{ebma_mc_tol} is called from within \code{ebma}. It tunes using
multiple cores.
}
\examples{
\dontrun{
# not yet
}
}
