% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_radar.R
\name{plot_radar}
\alias{plot_radar}
\alias{plotModelRanking}
\title{Model Ranking Plot}
\usage{
plot_radar(object, ..., verbose = TRUE)

plotModelRanking(object, ..., verbose = TRUE)
}
\arguments{
\item{object}{An object of class 'auditor_model_performance' created with \code{\link{model_performance}} function.}

\item{...}{Other auditor_model_performance' objects to be plotted together.}

\item{verbose}{Logical, indicates whether values of scores should be printed.}
}
\value{
ggplot object
}
\description{
Radar plot with model score. score are scaled to [0,1], each score is inversed and divided by maximum score value.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mp_lm <- model_performance(exp_lm)


library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mp_rf <- model_performance(exp_rf)

# plot results
plot_radar(mp_lm, mp_rf)

}
