% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_rec.R
\name{score_rec}
\alias{score_rec}
\alias{scoreREC}
\title{Area Over the Curve for REC Curves}
\usage{
score_rec(object)

scoreREC(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
an object of class 'score_audit'.
}
\description{
The area over the Regression Error Characteristic curve is a measure of the expected error
for the regression model.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
lm_model <- lm(life_length ~ ., data = dragons)

# create an explainer
lm_exp <- DALEX::explain(lm_model, data = dragons, y = dragons$life_length)

# calculate score
score_rec(lm_exp)


}
\references{
J. Bi, and K. P. Bennet, "Regression error characteristic curves," in Proc. 20th Int. Conf. Machine Learning, Washington DC, 2003, pp. 43-50
}
\seealso{
\code{\link{plot_rec}}
}
