% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLIFT.R
\name{plotLIFT}
\alias{plotLIFT}
\title{LIFT Chart}
\usage{
plotLIFT(object, ..., groups = 10, cumulative = TRUE)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{groups}{Number of groups.}

\item{cumulative}{If TRUE cumulative lift curve will be plotted.}
}
\value{
ggplot object
}
\description{
LIFT Chart shows the ratio of a model to a random guess.
}
\details{
Response vector provided by y argument in audit function should be an integer vector containing binary labels with values 0,1.
}
\examples{
library(mlbench)
data("PimaIndiansDiabetes")
Pima <- PimaIndiansDiabetes
Pima$diabetes <- ifelse(Pima$diabetes == "pos", 1, 0)
glm_model <- glm(diabetes~., family=binomial,	data=Pima)
glm_au <- audit(glm_model, data = Pima, y = Pima$diabetes)
plotLIFT(glm_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
