% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_from_rmds.R
\name{att_from_rmds}
\alias{att_from_rmds}
\title{Get all packages called in vignettes folder}
\usage{
att_from_rmds(path = "vignettes", recursive = TRUE, warn = -1)
}
\arguments{
\item{path}{path to directory with Rmds or vector of Rmd files}

\item{recursive}{logical. Should the listing recurse into directories?}

\item{warn}{-1 for quiet warnings with purl, 0 to see warnings}
}
\value{
Character vector of packages called with library or require.
{knitr} and {rmarkdown} are added by default to allow building the vignettes
 if the directory contains "vignettes" in the path
}
\description{
Get all packages called in vignettes folder
}
\examples{
dummypackage <- system.file("dummypackage",package = "attachment")
# browseURL(dummypackage)
att_from_rmds(path = file.path(dummypackage,"vignettes"))
}
