% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtomEntry.R
\docType{class}
\name{AtomEntry}
\alias{AtomEntry}
\title{Atom Entry class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an Atom Entry
}
\description{
This class models an atom Entry
}
\details{
AtomEntry
}
\examples{
 \dontrun{
  #encoding
  atom <- AtomEntry$new()
  atom$setId("my-atom-entry")
  atom$setTitle("My Atom feed entry")
  atom$setSummary("My Atom feed entry very comprehensive abstract")
  author1 <- AtomAuthor$new(
    name = "John Doe",
    uri = "http://www.atomxml.com/johndoe",
    email = "johndoe@atom4R.com"
  )
  atom$addAuthor(author1)
  author2 <- AtomAuthor$new(
    name = "John Doe's sister",
    uri = "http://www.atomxml.com/johndoesister",
    email = "johndoesister@atom4R.com"
  )
  atom$addAuthor(author2)
  contrib1 <- AtomContributor$new(
    name = "Contrib1",
    uri = "http://www.atomxml.com/contrib1",
    email = "contrib1@atom4R.com"
  )
  atom$addContributor(contrib1)
  contrib2 <- AtomContributor$new(
    name = "Contrib2",
    uri = "http://www.atomxml.com/contrib2",
    email = "contrib2@atom4R.com"
  )
  atom$addContributor(contrib2)
  atom$addCategory("draft", "dataset")
  atom$addCategory("world", "spatial")
  atom$addCategory("fisheries", "domain")

  xml <- atom$encode()
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Entry}
\keyword{atom}
\section{Super classes}{
\code{\link[atom4R:atom4RLogger]{atom4R::atom4RLogger}} -> \code{\link[atom4R:AtomAbstractObject]{atom4R::AtomAbstractObject}} -> \code{AtomEntry}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{identifier}

\item{\code{updated}}{Update date/time}

\item{\code{published}}{Publication date/time}

\item{\code{title}}{Title}

\item{\code{summary}}{Summary}

\item{\code{rights}}{Rights}

\item{\code{source}}{Source}

\item{\code{author}}{Author(s)}

\item{\code{contributor}}{Contributor(s)}

\item{\code{category}}{Category}

\item{\code{content}}{Content}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AtomEntry$new()}}
\item \href{#method-setId}{\code{AtomEntry$setId()}}
\item \href{#method-setUpdated}{\code{AtomEntry$setUpdated()}}
\item \href{#method-setPublished}{\code{AtomEntry$setPublished()}}
\item \href{#method-setTitle}{\code{AtomEntry$setTitle()}}
\item \href{#method-setSummary}{\code{AtomEntry$setSummary()}}
\item \href{#method-setRights}{\code{AtomEntry$setRights()}}
\item \href{#method-setSource}{\code{AtomEntry$setSource()}}
\item \href{#method-addAuthor}{\code{AtomEntry$addAuthor()}}
\item \href{#method-delAuthor}{\code{AtomEntry$delAuthor()}}
\item \href{#method-addContributor}{\code{AtomEntry$addContributor()}}
\item \href{#method-delContributor}{\code{AtomEntry$delContributor()}}
\item \href{#method-addCategory}{\code{AtomEntry$addCategory()}}
\item \href{#method-delCategory}{\code{AtomEntry$delCategory()}}
\item \href{#method-addLink}{\code{AtomEntry$addLink()}}
\item \href{#method-delLink}{\code{AtomEntry$delLink()}}
\item \href{#method-setContent}{\code{AtomEntry$setContent()}}
\item \href{#method-clone}{\code{AtomEntry$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="ERROR">}\href{../../atom4R/html/atom4RLogger.html#method-ERROR}{\code{atom4R::atom4RLogger$ERROR()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="INFO">}\href{../../atom4R/html/atom4RLogger.html#method-INFO}{\code{atom4R::atom4RLogger$INFO()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="logger">}\href{../../atom4R/html/atom4RLogger.html#method-logger}{\code{atom4R::atom4RLogger$logger()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="WARN">}\href{../../atom4R/html/atom4RLogger.html#method-WARN}{\code{atom4R::atom4RLogger$WARN()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="addListElement">}\href{../../atom4R/html/AtomAbstractObject.html#method-addListElement}{\code{atom4R::AtomAbstractObject$addListElement()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="contains">}\href{../../atom4R/html/AtomAbstractObject.html#method-contains}{\code{atom4R::AtomAbstractObject$contains()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="createElement">}\href{../../atom4R/html/AtomAbstractObject.html#method-createElement}{\code{atom4R::AtomAbstractObject$createElement()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="decode">}\href{../../atom4R/html/AtomAbstractObject.html#method-decode}{\code{atom4R::AtomAbstractObject$decode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="delListElement">}\href{../../atom4R/html/AtomAbstractObject.html#method-delListElement}{\code{atom4R::AtomAbstractObject$delListElement()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="encode">}\href{../../atom4R/html/AtomAbstractObject.html#method-encode}{\code{atom4R::AtomAbstractObject$encode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getClass">}\href{../../atom4R/html/AtomAbstractObject.html#method-getClass}{\code{atom4R::AtomAbstractObject$getClass()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getClassName">}\href{../../atom4R/html/AtomAbstractObject.html#method-getClassName}{\code{atom4R::AtomAbstractObject$getClassName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getNamespace">}\href{../../atom4R/html/AtomAbstractObject.html#method-getNamespace}{\code{atom4R::AtomAbstractObject$getNamespace()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getNamespaceDefinition">}\href{../../atom4R/html/AtomAbstractObject.html#method-getNamespaceDefinition}{\code{atom4R::AtomAbstractObject$getNamespaceDefinition()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getRootElement">}\href{../../atom4R/html/AtomAbstractObject.html#method-getRootElement}{\code{atom4R::AtomAbstractObject$getRootElement()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="getXmlElement">}\href{../../atom4R/html/AtomAbstractObject.html#method-getXmlElement}{\code{atom4R::AtomAbstractObject$getXmlElement()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="isDocument">}\href{../../atom4R/html/AtomAbstractObject.html#method-isDocument}{\code{atom4R::AtomAbstractObject$isDocument()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="isFieldInheritedFrom">}\href{../../atom4R/html/AtomAbstractObject.html#method-isFieldInheritedFrom}{\code{atom4R::AtomAbstractObject$isFieldInheritedFrom()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="print">}\href{../../atom4R/html/AtomAbstractObject.html#method-print}{\code{atom4R::AtomAbstractObject$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="save">}\href{../../atom4R/html/AtomAbstractObject.html#method-save}{\code{atom4R::AtomAbstractObject$save()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="setIsDocument">}\href{../../atom4R/html/AtomAbstractObject.html#method-setIsDocument}{\code{atom4R::AtomAbstractObject$setIsDocument()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="atom4R" data-topic="AtomAbstractObject" data-id="validate">}\href{../../atom4R/html/AtomAbstractObject.html#method-validate}{\code{atom4R::AtomAbstractObject$validate()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes an \link{AtomEntry}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setId"></a>}}
\if{latex}{\out{\hypertarget{method-setId}{}}}
\subsection{Method \code{setId()}}{
Set ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setId(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setUpdated"></a>}}
\if{latex}{\out{\hypertarget{method-setUpdated}{}}}
\subsection{Method \code{setUpdated()}}{
Set updated date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setUpdated(updated)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{updated}}{object of class \code{Date} or \code{POSIXt}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setPublished"></a>}}
\if{latex}{\out{\hypertarget{method-setPublished}{}}}
\subsection{Method \code{setPublished()}}{
Set published date
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setPublished(published)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{published}}{object of class \code{Date} or \code{POSIXt}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setTitle(title, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{title}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSummary"></a>}}
\if{latex}{\out{\hypertarget{method-setSummary}{}}}
\subsection{Method \code{setSummary()}}{
Set summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setSummary(summary, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{summary}}{summary}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setRights"></a>}}
\if{latex}{\out{\hypertarget{method-setRights}{}}}
\subsection{Method \code{setRights()}}{
Set rights
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setRights(rights, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rights}}{rights}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSource"></a>}}
\if{latex}{\out{\hypertarget{method-setSource}{}}}
\subsection{Method \code{setSource()}}{
Set source
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setSource(source, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addAuthor"></a>}}
\if{latex}{\out{\hypertarget{method-addAuthor}{}}}
\subsection{Method \code{addAuthor()}}{
Adds author
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addAuthor(author)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{author}}{object of class \link{AtomAuthor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delAuthor"></a>}}
\if{latex}{\out{\hypertarget{method-delAuthor}{}}}
\subsection{Method \code{delAuthor()}}{
Deletes author
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delAuthor(author)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{author}}{object of class \link{AtomAuthor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addContributor"></a>}}
\if{latex}{\out{\hypertarget{method-addContributor}{}}}
\subsection{Method \code{addContributor()}}{
Adds contributor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addContributor(contributor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contributor}}{object of class \link{AtomContributor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delContributor"></a>}}
\if{latex}{\out{\hypertarget{method-delContributor}{}}}
\subsection{Method \code{delContributor()}}{
Deletes contributor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delContributor(contributor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{contributor}}{object of class \link{AtomContributor}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addCategory"></a>}}
\if{latex}{\out{\hypertarget{method-addCategory}{}}}
\subsection{Method \code{addCategory()}}{
Adds category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addCategory(value, term, scheme = NULL, label = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value}

\item{\code{term}}{term}

\item{\code{scheme}}{scheme}

\item{\code{label}}{label}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delCategory"></a>}}
\if{latex}{\out{\hypertarget{method-delCategory}{}}}
\subsection{Method \code{delCategory()}}{
Deletes category
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delCategory(value, term, scheme = NULL, label = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value}

\item{\code{term}}{term}

\item{\code{scheme}}{scheme}

\item{\code{label}}{label}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addLink"></a>}}
\if{latex}{\out{\hypertarget{method-addLink}{}}}
\subsection{Method \code{addLink()}}{
Adds link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$addLink(link, rel = "alternate", type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{rel}}{relation. Default is "alternate"}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delLink"></a>}}
\if{latex}{\out{\hypertarget{method-delLink}{}}}
\subsection{Method \code{delLink()}}{
Deletes link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$delLink(link, rel = "alternate", type = "text/html")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{link}

\item{\code{rel}}{relation. Default is "alternate"}

\item{\code{type}}{type. Default is "text/html"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setContent"></a>}}
\if{latex}{\out{\hypertarget{method-setContent}{}}}
\subsection{Method \code{setContent()}}{
Set content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$setContent(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{content}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomEntry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
