% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.R
\name{pausables}
\alias{pausables}
\title{Pausable functions.}
\usage{
pausables(envir = caller(), packages = NULL)
}
\arguments{
\item{envir}{The environment to search (defaulting to the calling
environment).}

\item{packages}{By default, will only look for pausable functions
visible from the caller's environment. \code{packages} argument
additionally specifies aditional packages to
search. \code{packages=base::.packages()} will search all currently
loaded packages. \verb{[.packages(all.available=TRUE)]} will search
all installped package.}
}
\value{
A list of expressions (either names or \code{:::} calls)
}
\description{
Coroutines rely on "pausable" workalikes for control flow functions
like \code{if}, \code{while}, and so on. \code{pausables()} scans for and returns
a list of all pausable functions visible from the present
environment.
}
\details{
A pausable function is a public function that has a corresponding
private function with a name endng with \verb{_cps}.  Most of these
private functions are defined in \code{async} source file \code{cps.r}. For
instance, \code{async:::for_cps} contains the pausable implementation of
\code{for}.
}
