% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coroutine.R, R/gen.R, R/async.R, R/stream.R
\name{format.coroutine}
\alias{format.coroutine}
\alias{summary.coroutine}
\alias{summary.generator}
\alias{summary.async}
\alias{summary.stream}
\title{Query / display coroutine properties and state.}
\usage{
\method{format}{coroutine}(x, ...)

\method{summary}{coroutine}(object, ...)

\method{summary}{generator}(object, ...)

\method{summary}{async}(object, ...)

\method{summary}{stream}(object, ...)
}
\arguments{
\item{x}{A coroutine.}

\item{...}{Undocumented.}

\item{object}{a coroutine (\link{async}, \link[=gen]{generator}, or \link{stream}) object.}
}
\description{
The coroutine \code{format} method displays its source code, its
effective environment, whether it is running or finished, and a
label indicating its last known state. The \code{summary} method
returns the same information in a list.

\code{summary(obj)} returns a list with information on a coroutine's state,  including:
\itemize{
\item \code{code}: the expression used to create the coroutine;
\item \code{state}: the current state (see below);
\item \code{node}: is a character string that
identifies a location in the coroutine source code; for example,
a typical state string might be ".\{.<-2.await__then", which
can be read like "in the first argument of \verb{\\\{}, in the second
argument of \verb{<-}, in a call to \code{await()}, at internal node \code{then}.";
\item \code{envir}: the environment where the coroutine is evaluating R expressions;
\item \code{err}: the error object, if the coroutine caught an error.
}

\code{summary(g)$state} for a \link[=gen]{generator} \code{g} might be  "yielded",
"running" (if nextElem is \emph{currently} being called,) "stopped" (for
generators that have stopped with an error,) or "finished" (for
generators that have finished normally.)

\code{summary(a)$state} of an \link{async} might be "pending", "resolved" or
"rejected".

\code{summary(s)$state} on a \link{stream} might be "resolved",
"rejected", "running", "woken", "yielding", or "yielded".
}
