% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-range}
\alias{node-range}
\alias{node_range}
\alias{node_range_all}
\title{Get the start and end positions of a node}
\usage{
node_range(x)

node_range_all(x)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}
}
\value{
A list of two elements: \code{start} and \code{end}. Each of those is a vector
with two values indicating the row and column. Those are 0-indexed.
}
\description{
Get the start and end positions of a node
}
\examples{
src <- "x <- rnorm(100, mean = 2)
    any(duplicated(y))
    plot(x)
    any(duplicated(x))"

root <- src |>
  tree_new() |>
  tree_root()

node_range(root)

root |>
  node_find(ast_rule(pattern = "rnorm($$$A)")) |>
  node_range()

# There is also an "_all" variant when there are several nodes per rule
root |>
  node_find_all(
    ast_rule(pattern = "any(duplicated($A))"),
    ast_rule(pattern = "plot($A)")
  ) |>
  node_range_all()
}
