% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-redux.R
\name{num_row_NAs}
\alias{num_row_NAs}
\title{Counts number of NAs in each row}
\usage{
num_row_NAs(data, allow.NaN = FALSE)
}
\arguments{
\item{data}{A data frame}

\item{allow.NaN}{Treat NaN like NA (by counting it). FALSE by default}
}
\value{
A vector of number of missing values in each row
}
\description{
This function will return a vector, with the same length as the number
of rows of the provided data frame, corresponding to the number of missing
values in each row
}
\examples{

num_row_NAs(mtcars)


library(magrittr)            # for piping operator
library(dplyr)               # for "everything()" function

# using every column from mtcars, make sure there are at most
# 2 NAs in each row. If there are any more than two, error out
mtcars \%>\%
  assert_rows(num_row_NAs, within_bounds(0,2), everything())
  ## anything here will run

}
\seealso{
\code{\link{is.na}} \code{\link{is.nan}} \code{\link{not_na}}
}

