% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert}
\alias{assert}
\title{Raises error if predicate is FALSE in any columns selected}
\usage{
assert(data, predicate, ...)
}
\arguments{
\item{data}{A data frame}

\item{predicate}{A function that returns FALSE when violated}

\item{...}{Comma separated list of unquoted expressions.
           You can treat variable names like they are positions.
           Use positive values to select variables; use negative
           values to drop variables.}
}
\value{
data if predicate assertion is TRUE. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function will
just return the data it's supplied if there are no FALSEs
when the predicate is applied to every element of the columns
indicated. If any element in any of the columns, when applied
to the predicate, is FALSE, then this function will raise an
error, effectively terminating the pipeline early.
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{
assert(mtcars, not_na, vs)           # returns mtcars

assert(mtcars, not_na, mpg:carb)     # return mtcars

library(magrittr)                    # for piping operator

mtcars \%>\%
  assert(in_set(c(0,1)), vs)
  # anything here will run

\dontrun{
mtcars \%>\%
  assert(in_set(c(1, 2, 3, 4, 6)), carb)
  # the assertion is untrue so
  # nothing here will run}
}
\seealso{
\code{\link{verify}} \code{\link{insist}}
}

